<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "client".
 *
 * @property int $id
 * @property string $no
 * @property string $name
 * @property string $phone
 * @property string $email
 * @property string $address
 * @property string $town
 * @property string $country
 * @property float $balance
 * @property string|null $created
 */
class Client extends \yii\db\ActiveRecord
{
    // Define virtual attributes to hold the login data from the modal
    public $username;
    public $password;
    public $password_confirm;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'client';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'phone', 'email'], 'required'],
            [['email'], 'email'],
            [['balance'], 'number'],
            // 2. Mark them as 'safe' so the load() method accepts them
            [['no', 'address', 'town', 'country', 'username', 'password', 'password_confirm'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'no' => 'No',
            'name' => 'Name',
            'phone' => 'Phone',
            'email' => 'Email',
            'address' => 'Address',
            'town' => 'Town',
            'country' => 'Country',
            'balance' => 'Balance',
            'created' => 'Created',
        ];
    }

}
