<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Client;

class ClientSearch extends Client
{
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['no', 'name', 'phone', 'email', 'address', 'town', 'country'], 'safe'],
            [['balance'], 'number'],
        ];
    }

    public function search($params)
    {
        $query = Client::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // Grid filtering conditions
        $query->andFilterWhere(['id' => $this->id])
              ->andFilterWhere(['like', 'no', $this->no])
              ->andFilterWhere(['like', 'name', $this->name])
              ->andFilterWhere(['like', 'email', $this->email]);

        return $dataProvider;
    }
}