<?php
use yii\helpers\Url;
use yii\helpers\Html;

$this->title = 'Moesride Dashboard';
?>

<style>
    /* Modern UI Refinements */
    .main-content { background-color: #f8fafc; }
    
    /* Stat Cards with Glass Effect */
    .stat-card { 
        border: none; 
        border-radius: 16px; 
        background: #ffffff;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .stat-card:hover { 
        transform: translateY(-5px); 
        box-shadow: 0 12px 24px -10px rgba(0,0,0,0.1) !important; 
    }

    /* Icon Styling */
    .icon-box { 
        width: 48px; 
        height: 48px; 
        border-radius: 12px; 
        display: flex; 
        align-items: center; 
        justify-content: center; 
        font-size: 22px; 
    }

    /* Table Decoration */
    .table-card { border-radius: 16px; border: none; background: #ffffff; }
    .table thead th { 
        background-color: #f1f5f9; 
        color: #64748b; 
        font-size: 0.75rem; 
        text-transform: uppercase; 
        letter-spacing: 0.025em;
        border: none;
        padding: 1rem;
    }
    
    .table tbody td { padding: 1rem; vertical-align: middle; border-bottom: 1px solid #f1f5f9; }

    /* Modern Badges */
    .badge-pill { 
        border-radius: 6px; 
        padding: 6px 10px; 
        font-weight: 600; 
        font-size: 0.7rem; 
    }

    /* Left-accent border logic */
    .accent-primary { border-left: 5px solid #4e73df; }
    .accent-info { border-left: 5px solid #36b9cc; }
    .accent-success { border-left: 5px solid #1cc88a; }
    .accent-warning { border-left: 5px solid #f6c23e; }
</style>

<div class="container-fluid pt-4 pb-5">
    
    <div class="d-flex justify-content-between align-items-end mb-4">
        <div>
            <h2 class="fw-bold text-dark mb-0">Overview</h2>
            <p class="text-muted small mb-0">Real-time status of Moesride Logistics</p>
        </div>
        <a href="<?= Url::to(['car/index']) ?>" class="btn btn-primary shadow-sm px-4 rounded-3">
            <i class="bi bi-plus-lg me-2"></i> New Shipment
        </a>
    </div>

    <div class="row g-4 mb-5">
        <div class="col-md-3">
            <div class="card stat-card accent-primary shadow-sm p-3">
                <div class="d-flex align-items-center">
                    <div class="icon-box bg-primary-subtle text-primary"><i class="bi bi-truck"></i></div>
                    <div class="ms-3">
                        <small class="text-muted fw-bold text-uppercase" style="font-size: 0.65rem;">Total Cars</small>
                        <h3 class="fw-bold mb-0"><?= number_format($totalCars) ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card accent-info shadow-sm p-3">
                <div class="d-flex align-items-center">
                    <div class="icon-box bg-info-subtle text-info"><i class="bi bi-people"></i></div>
                    <div class="ms-3">
                        <small class="text-muted fw-bold text-uppercase" style="font-size: 0.65rem;">Clients</small>
                        <h3 class="fw-bold mb-0"><?= number_format($totalClients) ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card accent-success shadow-sm p-3">
                <div class="d-flex align-items-center">
                    <div class="icon-box bg-success-subtle text-success"><i class="bi bi-check-circle"></i></div>
                    <div class="ms-3">
                        <small class="text-muted fw-bold text-uppercase" style="font-size: 0.65rem;">Paid Units</small>
                        <h3 class="fw-bold mb-0"><?= number_format($paidCars) ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card accent-warning shadow-sm p-3">
                <div class="d-flex align-items-center">
                    <div class="icon-box bg-warning-subtle text-warning"><i class="bi bi-clock-history"></i></div>
                    <div class="ms-3">
                        <small class="text-muted fw-bold text-uppercase" style="font-size: 0.65rem;">Pending</small>
                        <h3 class="fw-bold mb-0"><?= number_format($unpaidCars) ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-md-8">
            <div class="card table-card shadow-sm">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center border-0">
                    <h5 class="fw-bold mb-0 text-dark">Recent Shipments</h5>
                    <a href="<?= Url::to(['car/index']) ?>" class="btn btn-sm btn-light text-primary fw-bold">View All</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead>
                                <tr>
                                    <th class="ps-4">Vehicle VIN / Lot</th>
                                    <th>Client</th>
                                    <th>Status</th>
                                    <th class="text-end pe-4">Details</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentCars as $car): ?>
                                <tr>
                                    <td class="ps-4">
                                        <div class="fw-bold text-dark"><?= Html::encode($car->vin) ?></div>
                                        <small class="text-muted">Lot No: <?= Html::encode($car->lot_no ?? '---') ?></small>
                                    </td>
                                    <td class="small fw-medium text-secondary">
                                        <?= $car->client ? Html::encode($car->client->name) : '<span class="text-light-emphasis">Unassigned</span>' ?>
                                    </td>
                                    <td>
                                        <?php if ($car->status === 'paid'): ?>
                                            <span class="badge bg-success-subtle text-success badge-pill">PAID</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning-subtle text-warning badge-pill">PENDING</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end pe-4">
                                        <a href="<?= Url::to(['car/view', 'id' => $car->id]) ?>" class="btn btn-sm btn-outline-secondary border-0">
                                            <i class="bi bi-arrow-right-circle-fill fs-5 text-primary"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card table-card shadow-sm">
                <div class="card-body p-4">
                    <h6 class="fw-bold text-dark mb-4">System Management</h6>
                    <div class="d-grid gap-3">
                        <a href="<?= Url::to(['auction/index']) ?>" class="text-decoration-none d-flex align-items-center p-3 rounded-3 bg-light text-dark hover-shadow">
                            <div class="icon-box bg-white shadow-sm me-3" style="width: 35px; height: 35px;"><i class="bi bi-hammer text-primary small"></i></div>
                            <span class="fw-bold small">Auctions</span>
                        </a>
                        <a href="<?= Url::to(['warehouse/index']) ?>" class="text-decoration-none d-flex align-items-center p-3 rounded-3 bg-light text-dark hover-shadow">
                            <div class="icon-box bg-white shadow-sm me-3" style="width: 35px; height: 35px;"><i class="bi bi-buildings text-primary small"></i></div>
                            <span class="fw-bold small">Warehouses</span>
                        </a>
                        <a href="<?= Url::to(['destination/index']) ?>" class="text-decoration-none d-flex align-items-center p-3 rounded-3 bg-light text-dark hover-shadow">
                            <div class="icon-box bg-white shadow-sm me-3" style="width: 35px; height: 35px;"><i class="bi bi-geo-alt text-primary small"></i></div>
                            <span class="fw-bold small">Destinations</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>