<?php
use yii\helpers\Url;
use yii\helpers\Html;

$user = Yii::$app->user->identity;
$controller = Yii::$app->controller->id;
$action = Yii::$app->controller->action->id;
?>

<ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="menu">
    
    <li class="nav-item">
        <a href="<?= Url::to(["/{$user->position}/index"]) ?>" 
           class="nav-link <?= ($controller === 'admin' || $controller === 'client') && $action === 'index' ? 'active' : '' ?>">
            <i class="nav-icon bi bi-speedometer2"></i>
            <p>Dashboard</p>
        </a>
    </li>

    <?php if ($user->position === 'admin'): ?>
        
        <li class="nav-header">DAILY PROCESSING</li>
        
        <li class="nav-item">
            <a href="<?= Url::to(['/car/index']) ?>" class="nav-link <?= $controller === 'car' ? 'active' : '' ?>">
                <i class="nav-icon bi bi-truck"></i>
                <p>Car Inventory</p>
            </a>
        </li>

        <li class="nav-item">
            <a href="<?= Url::to(['/client/index']) ?>" class="nav-link <?= $controller === 'client' ? 'active' : '' ?>">
                <i class="nav-icon bi bi-people"></i>
                <p>Manage Clients</p>
            </a>
        </li>

        <li class="nav-header">SYSTEM SETTINGS</li>
        
        <li class="nav-item <?= in_array($controller, ['auction', 'destination', 'warehouse', 'user']) ? 'menu-open' : '' ?>">
            <a href="#" class="nav-link <?= in_array($controller, ['auction', 'destination', 'warehouse', 'user']) ? 'active' : '' ?>">
                <i class="nav-icon bi bi-gear"></i>
                <p>
                    System Config
                    <i class="nav-arrow bi bi-chevron-right"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="<?= Url::to(['/auction/index']) ?>" class="nav-link <?= $controller === 'auction' ? 'active' : '' ?>">
                        <i class="nav-icon bi bi-hammer"></i>
                        <p>Auctions</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?= Url::to(['/destination/index']) ?>" class="nav-link <?= $controller === 'destination' ? 'active' : '' ?>">
                        <i class="nav-icon bi bi-geo-alt"></i>
                        <p>Destinations</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?= Url::to(['/warehouse/index']) ?>" class="nav-link <?= $controller === 'warehouse' ? 'active' : '' ?>">
                        <i class="nav-icon bi bi-buildings"></i>
                        <p>Warehouses</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?= Url::to(['/user/index']) ?>" class="nav-link <?= $controller === 'user' ? 'active' : '' ?>">
                        <i class="nav-icon bi bi-person-lock"></i>
                        <p>Staff Accounts</p>
                    </a>
                </li>
            </ul>
        </li>

    <?php elseif ($user->position === 'client'): ?>
        
        <li class="nav-header">MY SHIPMENTS</li>
        
        <li class="nav-item">
            <a href="<?= Url::to(['/car/index']) ?>" class="nav-link <?= $controller === 'car' ? 'active' : '' ?>">
                <i class="nav-icon bi bi-car-front"></i>
                <p>My Vehicles</p>
            </a>
        </li>

        <li class="nav-item">
            <a href="<?= Url::to(['/client/view', 'id' => $user->client_id]) ?>" 
               class="nav-link <?= $controller === 'client' && $action === 'view' ? 'active' : '' ?>">
                <i class="nav-icon bi bi-wallet2"></i>
                <p>Payment History</p>
            </a>
        </li>

        <li class="nav-item">
            <a href="<?= Url::to(['/site/contact']) ?>" class="nav-link">
                <i class="nav-icon bi bi-chat-dots"></i>
                <p>Support / Contact</p>
            </a>
        </li>

    <?php endif; ?>

    <li class="nav-item mt-auto">
        <hr class="text-secondary mx-3">
        <?= Html::beginForm(['/site/logout'], 'post') ?>
        <?= Html::submitButton(
            '<i class="nav-icon bi bi-box-arrow-right"></i> <p>Sign Out</p>',
            ['class' => 'nav-link btn btn-link text-start border-0 w-100 text-danger']
        ) ?>
        <?= Html::endForm() ?>
    </li>

</ul>