<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\ContactForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\captcha\Captcha;

$this->title = 'Support & Contact';

$this->registerCss(<<<CSS

@import url('https://fonts.googleapis.com/css2?family=Syne:wght@400;600;700;800&family=DM+Sans:ital,opsz,wght@0,9..40,300;0,9..40,400;0,9..40,500;1,9..40,300&display=swap');

.support-page {
    --brand:      #1a56db;
    --brand-soft: #eff4ff;
    --brand-dark: #1e40af;
    --accent:     #f59e0b;
    --success:    #059669;
    --surface:    #ffffff;
    --muted:      #6b7280;
    --border:     #e5e7eb;
    --text:       #111827;
    font-family: 'DM Sans', sans-serif;
    color: var(--text);
    min-height: 80vh;
    padding: 2.5rem 0 4rem;
}

/* ── Hero strip ───────────────────────────────────────── */
.support-hero {
    background: linear-gradient(135deg, #1e3a8a 0%, #1a56db 55%, #2563eb 100%);
    border-radius: 1.5rem;
    padding: 3rem 3rem 5rem;
    position: relative;
    overflow: hidden;
    margin-bottom: -3rem;
}
.support-hero::before {
    content: '';
    position: absolute;
    inset: 0;
    background:
        radial-gradient(ellipse 60% 80% at 90% 10%, rgba(255,255,255,0.07) 0%, transparent 60%),
        radial-gradient(ellipse 40% 60% at 10% 90%, rgba(245,158,11,0.12) 0%, transparent 60%);
}
.support-hero-label {
    font-family: 'Syne', sans-serif;
    font-size: 0.7rem;
    font-weight: 700;
    letter-spacing: 0.2em;
    text-transform: uppercase;
    color: rgba(255,255,255,0.55);
    margin-bottom: 0.75rem;
}
.support-hero h1 {
    font-family: 'Syne', sans-serif;
    font-size: clamp(1.8rem, 4vw, 2.8rem);
    font-weight: 800;
    color: #fff;
    line-height: 1.1;
    margin-bottom: 0.75rem;
}
.support-hero p {
    color: rgba(255,255,255,0.7);
    font-size: 1rem;
    font-weight: 300;
    max-width: 420px;
    line-height: 1.6;
    margin: 0;
}

/* Floating badge */
.support-hero-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: rgba(255,255,255,0.12);
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 2rem;
    padding: 0.4rem 1rem;
    font-size: 0.8rem;
    color: rgba(255,255,255,0.85);
    margin-bottom: 1.25rem;
    backdrop-filter: blur(4px);
}
.support-hero-badge span {
    width: 7px; height: 7px;
    background: #4ade80;
    border-radius: 50%;
    animation: pulse-green 2s infinite;
}
@keyframes pulse-green {
    0%,100% { opacity:1; transform:scale(1); }
    50%      { opacity:.5; transform:scale(1.4); }
}

/* ── Info cards (quick contact) ───────────────────────── */
.info-cards {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
    flex-wrap: wrap;
}
.info-card {
    background: rgba(255,255,255,0.1);
    border: 1px solid rgba(255,255,255,0.18);
    border-radius: 1rem;
    padding: 1rem 1.25rem;
    flex: 1;
    min-width: 160px;
    backdrop-filter: blur(6px);
}
.info-card i {
    font-size: 1.2rem;
    color: var(--accent);
    margin-bottom: 0.4rem;
    display: block;
}
.info-card .label {
    font-size: 0.7rem;
    letter-spacing: 0.1em;
    text-transform: uppercase;
    color: rgba(255,255,255,0.5);
    font-weight: 600;
}
.info-card .value {
    font-size: 0.9rem;
    color: #fff;
    font-weight: 500;
    margin-top: 0.1rem;
}

/* ── Form card ────────────────────────────────────────── */
.form-card {
    background: var(--surface);
    border-radius: 1.5rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1), 0 4px 16px rgba(0,0,0,0.06);
    padding: 2.5rem;
    position: relative;
    z-index: 2;
}
.form-card-title {
    font-family: 'Syne', sans-serif;
    font-size: 1.35rem;
    font-weight: 700;
    color: var(--text);
    margin-bottom: 0.25rem;
}
.form-card-sub {
    font-size: 0.88rem;
    color: var(--muted);
    margin-bottom: 2rem;
}

/* Custom form fields */
.field-group {
    margin-bottom: 1.25rem;
}
.field-group label {
    font-size: 0.78rem;
    font-weight: 600;
    letter-spacing: 0.06em;
    text-transform: uppercase;
    color: var(--muted);
    margin-bottom: 0.4rem;
    display: block;
}
.field-group .form-control,
.field-group textarea {
    border: 1.5px solid var(--border);
    border-radius: 0.75rem;
    padding: 0.75rem 1rem;
    font-size: 0.92rem;
    font-family: 'DM Sans', sans-serif;
    color: var(--text);
    background: #fafafa;
    transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
    width: 100%;
}
.field-group .form-control:focus,
.field-group textarea:focus {
    border-color: var(--brand);
    background: #fff;
    box-shadow: 0 0 0 4px rgba(26,86,219,0.1);
    outline: none;
}
.field-group textarea {
    resize: vertical;
    min-height: 130px;
}

/* Captcha row */
.captcha-wrap {
    background: var(--brand-soft);
    border: 1.5px solid #c7d7f9;
    border-radius: 0.75rem;
    padding: 1rem 1.25rem;
    display: flex;
    align-items: center;
    gap: 1.25rem;
    flex-wrap: wrap;
}
.captcha-wrap img {
    border-radius: 0.5rem;
    border: 1px solid #c7d7f9;
    cursor: pointer;
}
.captcha-wrap .form-control {
    flex: 1;
    min-width: 120px;
    border: 1.5px solid #c7d7f9;
    border-radius: 0.6rem;
    padding: 0.6rem 0.9rem;
    font-size: 0.9rem;
    background: #fff;
}
.captcha-wrap .form-control:focus {
    border-color: var(--brand);
    box-shadow: 0 0 0 3px rgba(26,86,219,0.1);
    outline: none;
}
.captcha-label {
    font-size: 0.72rem;
    color: var(--brand-dark);
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.08em;
    margin-bottom: 0.5rem;
}

/* Submit button */
.btn-send {
    background: linear-gradient(135deg, var(--brand) 0%, var(--brand-dark) 100%);
    color: #fff;
    border: none;
    border-radius: 0.85rem;
    padding: 0.85rem 2.5rem;
    font-family: 'Syne', sans-serif;
    font-size: 0.95rem;
    font-weight: 700;
    letter-spacing: 0.03em;
    cursor: pointer;
    transition: transform 0.15s, box-shadow 0.15s;
    box-shadow: 0 4px 16px rgba(26,86,219,0.35);
    width: 100%;
    margin-top: 0.5rem;
}
.btn-send:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 24px rgba(26,86,219,0.4);
}
.btn-send:active { transform: translateY(0); }
.btn-send i { margin-right: 0.5rem; }

/* ── Success state ────────────────────────────────────── */
.success-card {
    background: var(--surface);
    border-radius: 1.5rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
    padding: 3.5rem 2.5rem;
    text-align: center;
    position: relative;
    z-index: 2;
}
.success-icon {
    width: 72px; height: 72px;
    background: linear-gradient(135deg, #d1fae5, #a7f3d0);
    border-radius: 50%;
    display: flex; align-items: center; justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2rem;
    color: var(--success);
    box-shadow: 0 8px 24px rgba(5,150,105,0.2);
}
.success-card h3 {
    font-family: 'Syne', sans-serif;
    font-size: 1.5rem;
    font-weight: 800;
    color: var(--text);
    margin-bottom: 0.5rem;
}
.success-card p {
    color: var(--muted);
    font-size: 0.92rem;
    line-height: 1.6;
    max-width: 340px;
    margin: 0 auto 2rem;
}
.btn-back {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    background: var(--brand-soft);
    color: var(--brand);
    border: 1.5px solid #c7d7f9;
    border-radius: 0.75rem;
    padding: 0.65rem 1.5rem;
    font-weight: 600;
    font-size: 0.9rem;
    text-decoration: none;
    transition: background 0.2s, border-color 0.2s;
}
.btn-back:hover {
    background: #dbeafe;
    border-color: var(--brand);
    color: var(--brand-dark);
}

/* Validation error overrides */
.help-block { font-size: 0.78rem; color: #dc2626; margin-top: 0.3rem; }
.has-error .form-control { border-color: #fca5a5 !important; background: #fff5f5 !important; }

/* Responsive */
@media (max-width: 576px) {
    .support-hero { padding: 2rem 1.5rem 4.5rem; }
    .form-card    { padding: 1.75rem 1.25rem; }
    .info-cards   { gap: 0.75rem; }
}
CSS);
?>

<div class="support-page">
<div class="container" style="max-width:780px;">

    <!-- ── Hero ─────────────────────────────────────────── -->
    <div class="support-hero">
        <div class="support-hero-badge">
            <span></span> Support team is available
        </div>
        <div class="support-hero-label">Help &amp; Support</div>
        <h1>How can we<br>help you today?</h1>
        <p>Send us a message and our team will get back to you as soon as possible.</p>

        <div class="info-cards">
            <div class="info-card">
                <i class="bi bi-envelope-fill"></i>
                <div class="label">Email</div>
                <div class="value">support@moesride.com</div>
            </div>
            <div class="info-card">
                <i class="bi bi-telephone-fill"></i>
                <div class="label">Phone</div>
                <div class="value">+1 (555) 000-0000</div>
            </div>
            <div class="info-card">
                <i class="bi bi-clock-fill"></i>
                <div class="label">Hours</div>
                <div class="value">Mon–Fri, 9am–6pm</div>
            </div>
        </div>
    </div>

    <!-- ── Success / Form ────────────────────────────────── -->
    <?php if (Yii::$app->session->hasFlash('contactFormSubmitted')): ?>

        <div class="success-card">
            <div class="success-icon">
                <i class="bi bi-check-lg"></i>
            </div>
            <h3>Message Sent!</h3>
            <p>
                Thank you for reaching out. We've received your message and
                will respond within 1–2 business days.
            </p>
            <a href="<?= \yii\helpers\Url::to(['/client/dashboard']) ?>" class="btn-back">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>

    <?php else: ?>

        <div class="form-card">
            <div class="form-card-title">Send us a message</div>
            <div class="form-card-sub">Fill in the form below and we'll be in touch shortly.</div>

            <?php $form = ActiveForm::begin([
                'id'      => 'contact-form',
                'options' => ['novalidate' => true],
                'fieldConfig' => [
                    'template'  => "{label}\n{input}\n{error}",
                    'options'   => ['class' => 'field-group'],
                    'labelOptions' => ['class' => ''],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block'],
                ],
            ]); ?>

                <div class="row g-3">
                    <div class="col-sm-6">
                        <?= $form->field($model, 'name')->textInput([
                            'autofocus'   => true,
                            'placeholder' => 'Your full name',
                        ]) ?>
                    </div>
                    <div class="col-sm-6">
                        <?= $form->field($model, 'email')->input('email', [
                            'placeholder' => 'you@example.com',
                        ]) ?>
                    </div>
                </div>

                <?= $form->field($model, 'subject')->textInput([
                    'placeholder' => 'What is this regarding?',
                ]) ?>

                <?= $form->field($model, 'body')->textarea([
                    'rows'        => 6,
                    'placeholder' => 'Describe your issue or question in detail...',
                ]) ?>

                <!-- Captcha -->
                <div class="field-group">
                    <div class="captcha-label">
                        <i class="bi bi-shield-check me-1"></i>Security verification
                    </div>
                    <div class="captcha-wrap">
                        <?= Captcha::widget([
                            'name'    => 'ContactForm[verifyCode]',
                            'options' => ['class' => 'form-control', 'placeholder' => 'Enter code'],
                        ]) ?>
                    </div>
                    <?= $form->field($model, 'verifyCode', [
                        'template'  => "{error}",
                        'options'   => ['class' => ''],
                        'errorOptions' => ['class' => 'help-block mt-1'],
                    ])->hiddenInput() ?>
                </div>

                <button type="submit" class="btn-send">
                    <i class="bi bi-send-fill"></i> Send Message
                </button>

            <?php ActiveForm::end(); ?>
        </div>

    <?php endif; ?>

</div>
</div>
