<?php
/** @var \yii\web\View $this */
/** @var \yii\web\HttpException $exception */

$this->title = 'Access Denied';
?>

<div class="d-flex align-items-center justify-content-center"
     style="min-height: 70vh;">
    <div class="text-center px-4">

        <div class="mb-4" style="font-size: 6rem; line-height:1;">
            🚫
        </div>

        <h1 class="fw-bold text-danger mb-2" style="font-size:3rem;">403</h1>
        <h4 class="fw-bold mb-3">Access Denied</h4>
        <p class="text-muted mb-4" style="max-width:400px; margin:0 auto;">
            You don't have permission to access this page.
            Please go back to your dashboard.
        </p>

        <?php
        $identity = Yii::$app->user->identity;
        $dashUrl  = $identity && $identity->position === 'admin'
            ? \yii\helpers\Url::to(['/admin/index'])
            : \yii\helpers\Url::to(['/client/dashboard']);
        ?>

        <a href="<?= $dashUrl ?>"
           class="btn btn-primary rounded-pill px-5 shadow-sm fw-semibold">
            <i class="bi bi-house me-2"></i> Back to Dashboard
        </a>

    </div>
</div>
