<?php
use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Moesride Login';
?>

<p class="login-box-msg">Sign in to start your session</p>

<?php $form = ActiveForm::begin(['id' => 'login-form']); ?>

    <div class="input-group mb-3">
        <div class="form-floating">
            <?= $form->field($model, 'username', [
                // We only want the input and label here, error moves below the group
                'template' => "{input}{label}", 
                'options' => ['tag' => false],
            ])->textInput(['placeholder' => 'Username', 'autofocus' => true]) ?>
        </div>
        <div class="input-group-text">
            <span class="bi bi-envelope"></span>
        </div>
        <?= Html::error($model, 'username', ['class' => 'invalid-feedback d-block w-100']) ?>
    </div>

    <div class="input-group mb-3">
        <div class="form-floating">
            <?= $form->field($model, 'password', [
                'template' => "{input}{label}",
                'options' => ['tag' => false],
            ])->passwordInput(['placeholder' => 'Password']) ?>
        </div>
        <div class="input-group-text">
            <span class="bi bi-lock-fill"></span>
        </div>
        <?= Html::error($model, 'password', ['class' => 'invalid-feedback d-block w-100']) ?>
    </div>

    <div class="row align-items-center">
        <div class="col-8">
            <?= $form->field($model, 'rememberMe')->checkbox([
                'template' => "<div class=\"form-check\">{input} {label}</div>",
            ]) ?>
        </div>
        <div class="col-4">
            <div class="d-grid gap-2">
                <?= Html::submitButton('Sign In', ['class' => 'btn btn-primary', 'name' => 'login-button']) ?>
            </div>
        </div>
    </div>

<?php ActiveForm::end(); ?>